require( "scripts/style.lua" );
require( "scripts/transitions.lua" );
MakeDialog
{
	name = "credits",
	
	RWindow
	{
	    x = 0, y = 0, w = 800, h = 600,
        bgcolor = Color(132, 37, 54,255), 
        
        Bitmap
        {
            x = 0, y = 0,
            image = "ui/backgrounds/credits", 
            mask  = "ui/backgrounds/credits.mask", 
            
            ---------------------------------------------- Title
		    Text
		    {
			    x		= kCenter,
			    y		= 90,
			    w		= kMax,
			    h		= 75,
			    font	= {edwardian_medium, 45, WhiteColor},
			    name	= "credits_title_text",
			    flags	= kHAlignCenter + kVAlignTop,
			    label	= "#<outline color='400f17' size=3>"..GetString("credits_title").."</outline>",
		    },
		    -------------------------------------- Credits Version
	        Text
	        {
		        x		    = 0,
		        y		    = 465,
		        w		    = kMax,
		        h		    = 75,
		        font		= {edwardian_medium, 16, WhiteColor},
		        name		= "credits_version",
		        flags		= kHAlignCenter + kVAlignTop
	        }, 
		    ---------------------------------------------- Back
		    SetStyle(CSOvalGreenButtonStyle);
		    Button
		    {
			    x			= kCenter,
			    y			= 475,
			    label	    = "app_close",
			    command		=
				    function()
				        if(gDialogTable.context == "endgame") then
				            DoTransition( kFadeToBlack );
				            CloseWindow();
				            --PopModal( 'credits' );
				            --QuitToMainMenu();
				        else
				            DoTransition( kFadeToBlack );
				            PopModal( 'credits' ); 
				            PostMessage( CreateNamedMessage( kFadeFromBlack ) );
				        end
				    end
		    },
        },
        ---------------------------------------------- Credits
		TCredits
		{
			x			= 0, 
			y			= 140,
			w			= 800, 
			h			= 396,
			font		= edwardian_medium,			-- The font to use
			fontsize	= 18,						-- The size of our text
			fontcolor	= BlackColor,				-- The color of our text
			headercolor = WhiteColor,			    -- The color of our header
			columngap	= 50,						-- The gap in between columns
			columnwidth = 325,						-- The column width
			time		= 40000, 					-- Time to play credits in milliseconds
			intropause	= 2000, 					-- Time to pause credits at start, in ms
			file		= "credits/credits.txt"		-- The file to pull our credits from
		},
	},
}
PostMessage( CreateNamedMessage( kFadeFromBlack ) );